
%% "Encoding words into interval type-2 fuzzy sets using an interval
%% approach"  Feilong Liu and Jerry M. Mendel
%%  Programed by Feilong Liu
%% Modified by Jhiin Joo
% 
% 	 << Purpose >>
%	    Generate interval type-2 word models for words 
%
%	 << Internal Functions called by main.m >>
%		Fuzzistics.m  : This program is coded by Feilong Liu
%		centroid.m	  : This program is called from software on Mendel's website. 
%		
%		For the details of each function, see a comment in each 
%		MATLAB (*.m) file.
%%


function [wordsA_DR, MFs, CsA, ClA, CrA]=getFLIA_firstpart_nega(ppmenu11string)

%% -- Read Data------------------------------
A = xlsread('data_firstpart_Left1.xls'); %% read the data from the first part of the survey
[rowA, colA] = size(A);

%% --- Input the names of words --------------
ppmenu11string; %% Words for the FIRST SURVEY
MFsA=zeros(colA/2,9);

%% ---- compute the FOUs and centroids FOR THE FIRST SURVEY --------------------
for i=1:colA/2
    LA = A(1:rowA, 2*i-1);  %%Read the left end points for interval data.
    RA = A(1:rowA, 2*i);    %%Read the right end points for interval data.
    [MFsA(i,:),nA(i),Stat, NNum, Shift(i,:)] = Fuzzistics_FL1(LA,RA); %%Determine the interval type-2 MFs and the number of remaining interval data m* for each word.
    [CsA(i), ClA(i), CrA(i)]=centroid(MFsA(i,:)); %%Compute the center of the centroid and the centroid of interval type-2 MFs.
end


%% -- sort the MFs in ascending order according to the center of centroid FIRST SURVEY --
[CsA,indexA]=sort(CsA);  %% Sort the center of the centroid

MFsA=MFsA(indexA,:);     %% Reorder the MFs based on the sorting of the center of centroids
ClA=ClA(indexA);         %% Reorder the left end of the centroid.
CrA=CrA(indexA);         %% Reorder the right end of the centroid.
wordsA_DR=ppmenu11string(indexA,:); %%Reorder the names of words.

MFs=[];
for i=1:colA/2
    MFs(i,:)=antonym(MFsA(i,:)); %% ANTONYM words
end

